<?php $__env->startSection('title'); ?>
    <?php echo e($title); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
    
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/select2/css/select2.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')); ?>">
    <style>
        .new-user{
            float: right;
        }
        svg {
            width: 25px;
        }
    </style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('back-content'); ?>
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0 text-dark">User Document</h1>
        </div><!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Home</a></li>
            <li class="breadcrumb-item active"><?php echo e($title); ?></li>
          </ol>
        </div><!-- /.col -->
      </div><!-- /.row -->
    </div><!-- /.container-fluid -->
  </div>
  <section class="content">
    <div class="container-fluid">
        <div class="card card-success">
            <div class="card-header">
              <div class="row">
                  <div class="col-10"><h3 class="card-title"><?php echo e($title); ?></h3></div>
              </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body overflow-x">
              <table id="user-table" class="table table-bordered table-striped">
                <thead>
                <tr>
                    <th width="6%">ID</th>
                    <th>Name</th>
                    <th>Card Number</th>
                    <th>Type</th>
                    <th>Front</th>
                    <th>User With Document</th>
                    <th>Status</th>
                </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(find_user($data->user_id)): ?>
                            <tr>
                                <td><?php echo e(find_user($data->user_id)->code); ?></td>
                                <td><?php echo e($data->name); ?></td>
                                <td><?php echo e($data->card_number); ?></td>
                                <td><?php echo e($data->document_type); ?></td>
                                <td>
                                    <img src="<?php echo e(URL::to($data->document_front)); ?>" alt="Front" class="c-pointer" onclick="viewImage('<?php echo e(URL::to($data->document_front)); ?>')" style="height: 60px; width: 60px;">
                                </td>
                                <td>
                                    <img src="<?php echo e(URL::to($data->document_with_user)); ?>" alt="With User" class="c-pointer" onclick="viewImage('<?php echo e(URL::to($data->document_with_user)); ?>')" style="height: 60px; width: 60px;">
                                </td>
                                <td>
                                    <?php if($data->status == 0): ?>
                                        <span class="badge bg-warning">Under Review</span>
                                        <a href="javascript:;" class="btn btn-success btn-sm" data-toggle="modal" data-target="#edit_status_<?php echo e($data->id); ?>">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                    <?php elseif($data->status == 1): ?>
                                        <span class="badge bg-success p-2">Verified</span>
                                    <?php elseif($data->status == 2): ?>
                                        <span class="badge bg-danger p-2">Rejected</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <div class="modal fade" id="edit_status_<?php echo e($data->id); ?>" tabindex="-1" role="dialog" aria-labelledby="divisionEditModalLabel" aria-hidden="true">
                                <div class="modal-dialog" role="document">
                                    <form action="<?php echo e(route('admin.user-document-verify.update', $data->id)); ?>"
                                        method="POST">
                                        <?php echo csrf_field(); ?>
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel">Update Document Verification</h5>
                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">&times;</span>
                                                </button>
                                            </div>
                                            <div class="modal-body row">
                                                <div class="form-group col-lg-12 col-md-12 col-12">
                                                    <label for="status">Status</label>
                                                    <select class="form-control" name="status">
                                                        <option value="0" <?php if($data->status == 0): ?> selected <?php endif; ?>>Under Review</option>
                                                        <option value="1" <?php if($data->status == 1): ?> selected <?php endif; ?>>Verified</option>
                                                        <option value="2" <?php if($data->status == 2): ?> selected <?php endif; ?>>Rejected</option>
                                                    </select>
                                                </div>
                                                <div class="form-group col-lg-12 col-md-12 col-12">
                                                    <label for="reason">Reason</label>
                                                    <textarea class="form-control" name="reason" cols="30" rows="3"><?php echo e($data->reason); ?></textarea>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                <button type="submit" class="btn btn-primary">Update</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
              <div class="mt-4 text-center"><?php echo e($datas->onEachSide(1)->links()); ?></div>
            </div>
        </div>
    </div>
  </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('backend/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('backend/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
    
    <script src="<?php echo e(asset('backend/plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
    <!-- Select2 -->
    <script src="<?php echo e(asset('backend/plugins/select2/js/select2.full.min.js')); ?>"></script>

    <script>
        $(function () {
          $("#example1").DataTable({
            "responsive": true,
            "autoWidth": false,
          });
          $('#example2').DataTable({
            "paging": true,
            "lengthChange": false,
            "searching": false,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
          });
        });

        $(function () {
            $('.select2').select2();
        });

        // this function for image show when select image to upload database------------
        function readURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function (e){
                    $('#photo')
                        .attr('src', e.target.result)
                        .width(80)
                        .height(80);
                };
                reader.readAsDataURL(input.files[0]);
            }
        }
        $(function() {
          $("#filter").on("keyup", function() {
            var value = $(this).val().toLowerCase();
            $("#user-table > tbody > tr").filter(function() {      $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
            });
          });
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/powerwor/public_html/resources/views/backend/pages/usermanage/document-verify.blade.php ENDPATH**/ ?>